<?php
include 'db.php';

if (!isset($_GET['id'])) {
    die("Quotation ID is required.");
}
$id = intval($_GET['id']);

// Get quotation
$qry = $conn->prepare("SELECT * FROM quotations WHERE id=?");
$qry->bind_param("i", $id);
$qry->execute();
$quotation = $qry->get_result()->fetch_assoc();

if (!$quotation) {
    die("Quotation not found!");
}

// Get quotation items
$result = $conn->query("SELECT * FROM quotation_items WHERE quotation_id=$id");

// Calculate totals
$subtotal = 0;
$items = [];
while($row = $result->fetch_assoc()){
    $subtotal += $row['total'];
    $items[] = $row;
}
$sst = $quotation['sst_enabled'] ? $subtotal * 0.08 : 0;
$grand_total = $subtotal + $sst;
?>

<!DOCTYPE html>
<html>
<head>
    <title>View Quotation #<?php echo $quotation['id']; ?> - VSONIC ENGINEERING</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background:#f4f6f9; }
        .quotation-box { background:white; padding:30px; border-radius:10px; box-shadow:0 2px 6px rgba(0,0,0,0.1); }
        .table th, .table td { vertical-align: middle; }
        .company-title { font-size:22px; font-weight:bold; color:#333; }
        .footer-note { font-size:12px; font-style:italic; margin-top:20px; color:#555; }
    </style>
</head>
<body class="p-4">

<div class="quotation-box container">
    <div class="row mb-4">
        <div class="col text-center">
            <div class="company-title">VSONIC ENGINEERING</div>
            <div>Professional Quotation</div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col">
            <h5>To:</h5>
            <strong><?php echo htmlspecialchars($quotation['partner_name']); ?></strong><br>
            <pre style="white-space: pre-wrap;"><?php echo htmlspecialchars($quotation['partner_address']); ?></pre>
        </div>
        <div class="col text-end">
            <p><strong>Quotation No:</strong> <?php echo $quotation['id']; ?></p>
            <p><strong>Date:</strong> <?php echo $quotation['date_created']; ?></p>
        </div>
    </div>

    <table class="table table-bordered">
        <thead class="table-light">
            <tr>
                <th>Description</th>
                <th width="100">Qty</th>
                <th width="150">Unit Price</th>
                <th width="150">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($items as $item){ ?>
            <tr>
                <td><?php echo htmlspecialchars($item['description']); ?></td>
                <td class="text-center"><?php echo $item['quantity']; ?></td>
                <td class="text-end"><?php echo number_format($item['unit_price'],2); ?></td>
                <td class="text-end"><?php echo number_format($item['total'],2); ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

    <div class="row">
        <div class="col"></div>
        <div class="col-4">
            <table class="table">
                <tr>
                    <th>Subtotal</th>
                    <td class="text-end"><?php echo number_format($subtotal,2); ?></td>
                </tr>
                <?php if ($quotation['sst_enabled']) { ?>
                <tr>
                    <th>SST (8%)</th>
                    <td class="text-end"><?php echo number_format($sst,2); ?></td>
                </tr>
                <?php } ?>
                <tr class="table-light">
                    <th>Grand Total</th>
                    <td class="text-end"><strong><?php echo number_format($grand_total,2); ?></strong></td>
                </tr>
            </table>
        </div>
    </div>

    <div class="footer-note">
        This is a system-generated quotation from VSONIC ENGINEERING.  
        Thank you for your business.
    </div>

    <div class="mt-4 text-end">
        <a href="quotations_list.php" class="btn btn-secondary">Back</a>
        <a href="export_quotation_pdf.php?id=<?php echo $quotation['id']; ?>" class="btn btn-success">Download PDF</a>
        <a href="edit_quotation.php?id=<?php echo $quotation['id']; ?>" class="btn btn-warning">Edit</a>
    </div>
</div>

</body>
</html>
