<?php
include 'db.php';

// Load settings (assume single row with id=1)
$settings = $conn->query("SELECT * FROM payroll_settings WHERE id=1")->fetch_assoc();

// Handle update
if (isset($_POST['save'])) {
    $company_name        = $_POST['company_name'];
    $company_address     = $_POST['company_address'];
    $company_tel         = $_POST['company_tel'];
    $company_logo        = $_POST['company_logo'];
    $epf_employee_rate   = floatval($_POST['epf_employee_rate']);
    $epf_employer_rate   = floatval($_POST['epf_employer_rate']);
    $socso_employee_rate = floatval($_POST['socso_employee_rate']);
    $socso_employer_rate = floatval($_POST['socso_employer_rate']);
    $sip_employee        = floatval($_POST['sip_employee']);
    $payday_day          = intval($_POST['payday_day']);
    $default_basic       = floatval($_POST['default_basic']);
    $default_allowance   = floatval($_POST['default_allowance']);
    $id                  = 1;

    $stmt = $conn->prepare("
        UPDATE payroll_settings SET 
            company_name=?, 
            company_address=?, 
            company_tel=?, 
            company_logo=?, 
            epf_employee_rate=?, 
            epf_employer_rate=?, 
            socso_employee_rate=?, 
            socso_employer_rate=?, 
            sip_employee=?, 
            payday_day=?, 
            default_basic=?, 
            default_allowance=?,
            updated_at=NOW()
        WHERE id=?
    ");

    $stmt->bind_param(
        "ssssddddidddi",
        $company_name,
        $company_address,
        $company_tel,
        $company_logo,
        $epf_employee_rate,
        $epf_employer_rate,
        $socso_employee_rate,
        $socso_employer_rate,
        $sip_employee,
        $payday_day,
        $default_basic,
        $default_allowance,
        $id
    );

    if ($stmt->execute()) {
        echo "<script>alert('✅ Payroll settings updated successfully'); window.location='payroll_settings.php';</script>";
        exit;
    } else {
        echo "<script>alert('❌ Update failed: " . $stmt->error . "');</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payroll Settings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
    <h2 class="mb-4">⚙️ Payroll Settings</h2>
    <form method="post" class="card p-4 shadow-sm">
        <h5 class="mb-3">🏢 Company Info</h5>
        <div class="mb-3">
            <label class="form-label">Company Name</label>
            <input type="text" class="form-control" name="company_name" value="<?= htmlspecialchars($settings['company_name']) ?>" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Address</label>
            <textarea class="form-control" name="company_address" required><?= htmlspecialchars($settings['company_address']) ?></textarea>
        </div>
        <div class="mb-3">
            <label class="form-label">Telephone</label>
            <input type="text" class="form-control" name="company_tel" value="<?= htmlspecialchars($settings['company_tel']) ?>">
        </div>
        <div class="mb-3">
            <label class="form-label">Logo (path/URL)</label>
            <input type="text" class="form-control" name="company_logo" value="<?= htmlspecialchars($settings['company_logo']) ?>">
        </div>

        <h5 class="mb-3 mt-4">📊 Contribution Rates</h5>
        <div class="row">
            <div class="col-md-4 mb-3">
                <label class="form-label">EPF Employee (%)</label>
                <input type="number" step="0.01" class="form-control" name="epf_employee_rate" value="<?= htmlspecialchars($settings['epf_employee_rate']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">EPF Employer (%)</label>
                <input type="number" step="0.01" class="form-control" name="epf_employer_rate" value="<?= htmlspecialchars($settings['epf_employer_rate']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">SOCSO Employee (%)</label>
                <input type="number" step="0.01" class="form-control" name="socso_employee_rate" value="<?= htmlspecialchars($settings['socso_employee_rate']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">SOCSO Employer (%)</label>
                <input type="number" step="0.01" class="form-control" name="socso_employer_rate" value="<?= htmlspecialchars($settings['socso_employer_rate']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">SIP Employee (%)</label>
                <input type="number" step="0.01" class="form-control" name="sip_employee" value="<?= htmlspecialchars($settings['sip_employee']) ?>">
            </div>
        </div>

        <h5 class="mb-3 mt-4">💰 Defaults</h5>
        <div class="row">
            <div class="col-md-4 mb-3">
                <label class="form-label">Payday (Day of Month)</label>
                <input type="number" min="1" max="31" class="form-control" name="payday_day" value="<?= htmlspecialchars($settings['payday_day']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">Default Basic Salary</label>
                <input type="number" step="0.01" class="form-control" name="default_basic" value="<?= htmlspecialchars($settings['default_basic']) ?>">
            </div>
            <div class="col-md-4 mb-3">
                <label class="form-label">Default Allowance</label>
                <input type="number" step="0.01" class="form-control" name="default_allowance" value="<?= htmlspecialchars($settings['default_allowance']) ?>">
            </div>
        </div>

        <div class="d-flex justify-content-between mt-3">
            <a href="dashboard.php" class="btn btn-secondary">⬅ Back</a>
            <button type="submit" name="save" class="btn btn-primary">💾 Save Settings</button>
        </div>
    </form>
</body>
</html>
