<?php
include 'db.php';
$month = $_GET['month'] ?? date('Y-m');
$employee_id = isset($_GET['employee_id']) && $_GET['employee_id'] !== '' ? intval($_GET['employee_id']) : '';
$status = $_GET['status'] ?? '';

$where = [];
$where[] = "p.payroll_month = '{$month}'";
if ($employee_id) $where[] = "p.employee_id = {$employee_id}";
if ($status) $where[] = "p.status = '". $conn->real_escape_string($status) ."'";

$where_sql = "WHERE " . implode(" AND ", $where);

$sql = "SELECT p.*, e.name AS employee_name FROM payrolls p JOIN employees e ON p.employee_id = e.id {$where_sql} ORDER BY e.name";
$res = $conn->query($sql);

// load employees for filter
$emps = $conn->query("SELECT id, name FROM employees ORDER BY name");
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Payroll List</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="container py-4">
<h3>Payroll List for <?= htmlspecialchars($month) ?></h3>

<form method="get" class="row g-2 mb-3">
    <div class="col-md-3"><input type="month" name="month" class="form-control" value="<?= htmlspecialchars($month) ?>"></div>
    <div class="col-md-3">
        <select name="employee_id" class="form-select">
            <option value="">All Employees</option>
            <?php while($r = $emps->fetch_assoc()): ?>
                <option value="<?= $r['id'] ?>" <?= ($employee_id==$r['id'])?'selected':'' ?>><?= htmlspecialchars($r['name']) ?></option>
            <?php endwhile; ?>
        </select>
    </div>
    <div class="col-md-2">
        <select name="status" class="form-select">
            <option value="">All Status</option>
            <option value="Pending" <?= ($status=='Pending')?'selected':'' ?>>Pending</option>
            <option value="Issued" <?= ($status=='Issued')?'selected':'' ?>>Issued</option>
            <option value="Cancelled" <?= ($status=='Cancelled')?'selected':'' ?>>Cancelled</option>
        </select>
    </div>
    <div class="col-md-2"><button class="btn btn-primary">Filter</button></div>
    <div class="col-md-2 text-end">
        <a href="payroll_generate.php?month=<?= htmlspecialchars($month) ?>" class="btn btn-outline-secondary">Generate Payroll</a>
        <a href="payroll_print_month.php?month=<?= htmlspecialchars($month) ?>" class="btn btn-danger">Print All (PDF)</a>
    </div>
</form>

<table class="table table-bordered">
<thead><tr><th>Employee</th><th>Gross</th><th>Deductions</th><th>Net</th><th>Status</th><th>Actions</th></tr></thead>
<tbody>
<?php if ($res->num_rows): while($row = $res->fetch_assoc()): ?>
<tr>
    <td><?= htmlspecialchars($row['employee_name']) ?></td>
    <td>RM <?= number_format($row['gross'],2) ?></td>
    <td>RM <?= number_format($row['total_deductions'],2) ?></td>
    <td>RM <?= number_format($row['net_pay'],2) ?></td>
    <td><?= htmlspecialchars($row['status']) ?></td>
    <td>
        <a href="payslip.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-sm btn-outline-primary">Print</a>
        <a href="payroll_edit.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
    </td>
</tr>
<?php endwhile; else: ?>
<tr><td colspan="6" class="text-center">No records</td></tr>
<?php endif; ?>
</tbody>
</table>

</body></html>
