<?php include 'db.php'; ?>
<!DOCTYPE html>
<html>
<head>
    <title>Employee Management</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Employee List</h2>
    <a href="add.php">Add New Employee</a> | 
    <a href="export_pdf.php" target="_blank">Export to PDF</a>
    <br><br>
    <table>
    <tr>
        <th>ID</th><th>Name</th><th>Email</th><th>Phone</th><th>Address</th><th>Status</th><th>Date Joined</th><th>Date Left</th><th>Position</th><th>Actions</th>
    </tr>
    <?php
    $result = $conn->query("SELECT * FROM employees ORDER BY id DESC");
    while($row = $result->fetch_assoc()):
    ?>
    <tr>
        <td><?= $row['id'] ?></td>
        <td><?= $row['name'] ?></td>
        <td><?= $row['email'] ?></td>
        <td><?= $row['phone'] ?></td>
        <td><?= $row['address'] ?></td>
        <td><?= $row['status'] ?></td>
        <td><?= $row['date_joined'] ?></td>
        <td><?= $row['date_left'] ?></td>
        <td><?= $row['position'] ?></td>
        <td>
    <a href="edit.php?id=<?= $row['id'] ?>">Edit</a> | 
    <a href="delete.php?id=<?= $row['id'] ?>" onclick="return confirm('Delete this employee?')">Delete</a> | 
    <a href="payment_history.php?id=<?= $row['id'] ?>">Payments</a>
        </td>
        
    </tr>
    <?php endwhile; ?>
</table>
</body>
</html>


<?php
$conn = new mysqli("localhost", "root", "", "company_db");

// Total employees
$totalEmployees = $conn->query("SELECT COUNT(*) as total FROM employees")->fetch_assoc()['total'];

// Total departments
$totalDepartments = $conn->query("SELECT COUNT(DISTINCT position) as total FROM employees")->fetch_assoc()['total'];

// Active employees
$activeEmployees = $conn->query("SELECT COUNT(*) as total FROM employees WHERE status='Active'")->fetch_assoc()['total'];

// On leave
$onLeave = $conn->query("SELECT COUNT(*) as total FROM employees WHERE status='On Leave'")->fetch_assoc()['total'];

// Department distribution
$deptData = $conn->query("SELECT position, COUNT(*) as total FROM employees GROUP BY position");

$departments = [];
$deptCounts = [];
while($row = $deptData->fetch_assoc()){
    $position[] = $row['position'];
    $deptCounts[] = $row['total'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Employee Dashboard</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-light">
  <div class="container mt-4">
    <h2 class="mb-4 text-center">Employee System Dashboard</h2>
    
    <!-- Cards Row -->
    <div class="row mb-4">
      <div class="col-md-3">
        <div class="card text-white bg-primary shadow">
          <div class="card-body">
            <h5 class="card-title">Total Employees</h5>
            <h3><?php echo $totalEmployees; ?></h3>
          </div>
        </div>
      </div>
      
      <div class="col-md-3">
        <div class="card text-white bg-success shadow">
          <div class="card-body">
            <h5 class="card-title">Departments</h5>
            <h3><?php echo $totalDepartments; ?></h3>
          </div>
        </div>
      </div>
      
      <div class="col-md-3">
        <div class="card text-white bg-warning shadow">
          <div class="card-body">
            <h5 class="card-title">Active Employees</h5>
            <h3><?php echo $activeEmployees; ?></h3>
          </div>
        </div>
      </div>
      
      <div class="col-md-3">
        <div class="card text-white bg-danger shadow">
          <div class="card-body">
            <h5 class="card-title">On Leave</h5>
            <h3><?php echo $onLeave; ?></h3>
          </div>
        </div>
      </div>
    </div>

    <!-- Graphs Row -->
    <div class="row">
      <div class="col-md-6">
        <div class="card shadow">
          <div class="card-body">
            <h5 class="card-title">Employees by Department</h5>
            <canvas id="deptChart"></canvas>
          </div>
        </div>
      </div>
      
      <div class="col-md-6">
        <div class="card shadow">
          <div class="card-body">
            <h5 class="card-title">Employees by Status</h5>
            <canvas id="statusChart"></canvas>
          </div>
        </div>
      </div>
    </div>
    
  </div>

  <script>
    // Department Chart (example data, replace with PHP)
    const deptCtx = document.getElementById('deptChart');
    new Chart(deptCtx, {
      type: 'bar',
      data: {
        labels: <?php echo json_encode($departments); ?>,
        datasets: [{
          label: 'Employees',
          data: <?php echo json_encode($deptCounts); ?>,
          backgroundColor: 'rgba(54, 162, 235, 0.6)'
        }]
      }
    });

    // Status Chart (Active vs On Leave)
    const statusCtx = document.getElementById('statusChart');
    new Chart(statusCtx, {
      type: 'pie',
      data: {
        labels: ['Active', 'On Leave'],
        datasets: [{
          data: [<?php echo $activeEmployees; ?>, <?php echo $onLeave; ?>],
          backgroundColor: ['#28a745', '#dc3545']
        }]
      }
    });
  </script>
</body>
</html>