<?php
require('fpdf/fpdf.php'); // make sure you have FPDF in this folder

// Database connection
$servername = "localhost";
$username   = "root";   // change if you use another username
$password   = "";       // change if your MySQL has a password
$dbname     = "company_db";

// Connect
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Run query
$sql = "SELECT * FROM employees";
$result = $conn->query($sql);

if (!$result) {
    die("Query failed: " . $conn->error);
}

// Create PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',12);

// Header
$pdf->Cell(0,10,'Employee List',0,1,'C');
$pdf->Ln(5);

// Table header
$pdf->SetFont('Arial','B',10);
$pdf->Cell(20,10,'ID',1);
$pdf->Cell(40,10,'Name',1);
$pdf->Cell(40,10,'Position',1);
$pdf->Cell(50,10,'Email',1);
$pdf->Ln();

// Table body
$pdf->SetFont('Arial','',9);

while ($row = $result->fetch_assoc()) {
    $pdf->Cell(20,10,$row['id'],1);
    $pdf->Cell(40,10,$row['name'],1);
    $pdf->Cell(40,10,$row['position'],1);
    $pdf->Cell(50,10,$row['email'],1);
    $pdf->Ln();
}

// Close connection
$conn->close();

// Output PDF to browser
$pdf->Output('D', 'employees.pdf'); 
// 'D' = Download, 'I' = Inline (open in browser)
?>
