<?php
include 'db.php';
$id = $_GET['id'];

// Fetch invoice header
$invoice = $conn->query("SELECT * FROM invoices WHERE id=$id")->fetch_assoc();

// Fetch invoice items
$items = $conn->query("SELECT * FROM invoice_items WHERE invoice_id=$id");
?>

<!DOCTYPE html>
<html>
<head>
  <title>Edit Invoice</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script>
    function updateTotals() {
      let subtotal = 0;
      document.querySelectorAll('.item-row').forEach(row => {
        let qty = parseFloat(row.querySelector('.qty').value) || 0;
        let price = parseFloat(row.querySelector('.price').value) || 0;
        let total = qty * price;
        row.querySelector('.total').value = total.toFixed(2);
        subtotal += total;
      });
      document.getElementById('subtotal').value = subtotal.toFixed(2);

      let sstChecked = document.getElementById('apply_sst').checked;
      let sst = sstChecked ? subtotal * 0.08 : 0;
      document.getElementById('sst').value = sst.toFixed(2);
      document.getElementById('grand_total').value = (subtotal + sst).toFixed(2);
    }

    function addRow() {
      let table = document.getElementById('items');
      let row = table.insertRow();
      row.classList.add('item-row');
      row.innerHTML = `
        <td><input type="text" name="description[]" class="form-control"></td>
        <td><input type="number" name="qty[]" class="form-control qty" oninput="updateTotals()"></td>
        <td><input type="number" step="0.01" name="price[]" class="form-control price" oninput="updateTotals()"></td>
        <td><input type="text" class="form-control total" readonly></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove();updateTotals()">X</button></td>
      `;
    }
  </script>
</head>
<body class="p-4">
  <h2>Edit Invoice #<?php echo $invoice['id']; ?></h2>
  <form method="POST" action="update_invoice.php">
    <input type="hidden" name="id" value="<?php echo $invoice['id']; ?>">
    <div class="mb-2">
      <label>Business Partner</label>
      <input type="text" name="partner_name" class="form-control" value="<?php echo $invoice['partner_name']; ?>" required>
    </div>
    
    <div class="mb-2">
      <label>Address</label>
      <textarea name="partner_address" class="form-control"><?php echo $invoice['partner_address']; ?></textarea>
    </div>

    <table class="table" id="items">
      <tr>
        <th>Description</th><th>Qty</th><th>Unit Price</th><th>Total</th><th></th>
      </tr>
      <?php while($row = $items->fetch_assoc()){ ?>
      <tr class="item-row">
        <td><input type="text" name="description[]" value="<?php echo $row['description']; ?>" class="form-control"></td>
        <td><input type="number" name="qty[]" value="<?php echo $row['qty']; ?>" class="form-control qty" oninput="updateTotals()"></td>
        <td><input type="number" step="0.01" name="price[]" value="<?php echo $row['unit_price']; ?>" class="form-control price" oninput="updateTotals()"></td>
        <td><input type="text" value="<?php echo $row['total']; ?>" class="form-control total" readonly></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="this.closest('tr').remove();updateTotals()">X</button></td>
      </tr>
      <?php } ?>
    </table>
    <button type="button" class="btn btn-secondary" onclick="addRow()">Add Item</button>

    <div class="mt-3">
      <input type="checkbox" id="apply_sst" name="apply_sst" <?php echo $invoice['apply_sst']?'checked':''; ?> onclick="updateTotals()"> Apply SST (8%)
    </div>
    <div class="row mt-2">
      <div class="col-md-4">Subtotal: <input type="text" id="subtotal" class="form-control" readonly></div>
      <div class="col-md-4">SST: <input type="text" id="sst" class="form-control" readonly></div>
      <div class="col-md-4">Grand Total: <input type="text" id="grand_total" class="form-control" readonly></div>
    </div>

    <button type="submit" class="btn btn-success mt-3">Update Invoice</button>
  </form>
  <script>updateTotals();</script>
</body>
</html>
