<?php 
include 'db.php'; 

// Validate and get employee ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($id <= 0){
    die("Invalid employee ID.");
}

// Fetch employee data
$stmt = $conn->prepare("SELECT * FROM employees WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$emp = $result->fetch_assoc();

if(!$emp){
    die("Employee not found.");
}

// Handle update form
if(isset($_POST['update'])){
    $stmt = $conn->prepare("UPDATE employees 
        SET name=?, email=?, phone=?, address=?, status=?, date_joined=?, date_left=?, position=? 
        WHERE id=?");
    $stmt->bind_param("ssssssssi", 
        $_POST['name'], 
        $_POST['email'], 
        $_POST['phone'], 
        $_POST['address'], 
        $_POST['status'], 
        $_POST['date_joined'], 
        $_POST['date_left'], 
        $_POST['position'], 
        $id
    );
    $stmt->execute();

    // Redirect after update
    header("Location: index.php?msg=updated");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Employee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-3">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Edit Employee</h4>
        </div>
        <div class="card-body p-4">
            <form method="post" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Name</label>
                    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($emp['name']) ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($emp['email']) ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Phone</label>
                    <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($emp['phone']) ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Position</label>
                    <input type="text" name="position" class="form-control" value="<?= htmlspecialchars($emp['position']) ?>">
                </div>
                <div class="col-12">
                    <label class="form-label">Address</label>
                    <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($emp['address']) ?></textarea>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="Active" <?= $emp['status']=="Active"?"selected":"" ?>>Active</option>
                        <option value="Inactive" <?= $emp['status']=="Inactive"?"selected":"" ?>>Inactive</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Date Joined</label>
                    <input type="date" name="date_joined" class="form-control" value="<?= $emp['date_joined'] ?>">
                </div>
                <div class="col-md-4">
                    <label class="form-label">Date Left</label>
                    <input type="date" name="date_left" class="form-control" value="<?= $emp['date_left'] ?>">
                </div>
                <div class="col-12 text-end">
                    <button type="submit" name="update" class="btn btn-success px-4">Update</button>
                    <a href="index.php" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
